/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import com.kenai.jaffl.CallingConvention;
import com.kenai.jaffl.Library;
import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.struct.Struct;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import jnr.netdb.Service;
import jnr.netdb.ServicesDB;
import jnr.netdb.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NativeServicesDB
implements ServicesDB {
    private final LibServices lib;

    public NativeServicesDB(LibServices libServices) {
        this.lib = libServices;
    }

    public static final NativeServicesDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    static final NativeServicesDB load() {
        try {
            LibServices libServices;
            Platform.OS oS = Platform.getPlatform().getOS();
            if (!(oS.equals((Object)Platform.OS.DARWIN) || oS.equals((Object)Platform.OS.WINDOWS) && Platform.getPlatform().getCPU() == Platform.CPU.I386 || oS.equals((Object)Platform.OS.LINUX) || oS.equals((Object)Platform.OS.SOLARIS) || oS.equals((Object)Platform.OS.FREEBSD) || oS.equals((Object)Platform.OS.NETBSD))) {
                return null;
            }
            if (oS.equals((Object)Platform.OS.WINDOWS)) {
                HashMap<LibraryOption, CallingConvention> hashMap = new HashMap<LibraryOption, CallingConvention>();
                hashMap.put(LibraryOption.CallingConvention, CallingConvention.STDCALL);
                libServices = Library.loadLibrary(LibServices.class, hashMap, "Ws2_32");
            } else {
                String[] stringArray;
                if (oS.equals((Object)Platform.OS.SOLARIS)) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "socket";
                    stringArray2[1] = "nsl";
                    stringArray = stringArray2;
                    stringArray2[2] = "c";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "c";
                }
                String[] stringArray4 = stringArray;
                libServices = Library.loadLibrary(LibServices.class, stringArray4);
            }
            libServices.getservbyname("bootps", "udp");
            libServices.getservbyport(67, "udp");
            return new NativeServicesDB(libServices);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Service> getAllServices() {
        ArrayList<Service> arrayList = new ArrayList<Service>();
        try {
            UnixServent unixServent;
            while ((unixServent = this.lib.getservent()) != null) {
                arrayList.add(this.serviceFromNative(unixServent));
            }
        }
        finally {
            this.lib.endservent();
        }
        return arrayList;
    }

    private final Service serviceFromNative(UnixServent unixServent) {
        int n;
        if (unixServent == null) {
            return null;
        }
        int n2 = n = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? (int)Short.reverseBytes((short)unixServent.port.get()) : unixServent.port.get();
        if (n < 0) {
            n = (n & Short.MAX_VALUE) + 32768;
        }
        List list = Collections.emptyList();
        Pointer pointer = unixServent.aliases.get();
        List<String> list2 = pointer != null ? StringUtil.getNullTerminatedStringArray(pointer) : list;
        return unixServent != null ? new Service(unixServent.name.get(), n, unixServent.proto.get(), list2) : null;
    }

    @Override
    public Service getServiceByName(String string, String string2) {
        return this.serviceFromNative(this.lib.getservbyname(string, string2));
    }

    @Override
    public Service getServiceByPort(Integer n, String string) {
        short s = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? Short.reverseBytes(n.shortValue()) : n.shortValue();
        return this.serviceFromNative(this.lib.getservbyport(Integer.valueOf(s), string));
    }

    public static interface LibServices {
        public UnixServent getservbyname(String var1, String var2);

        public UnixServent getservbyport(Integer var1, String var2);

        public UnixServent getservent();

        public void endservent();
    }

    private static final class SingletonHolder {
        public static final NativeServicesDB INSTANCE = NativeServicesDB.load();

        private SingletonHolder() {
        }
    }

    public static class UnixServent
    extends Struct {
        public final Struct.String name = new Struct.UTF8StringRef();
        public final Struct.Pointer aliases = new Struct.Pointer();
        public final Struct.Signed32 port = new Struct.Signed32();
        public final Struct.String proto = new Struct.UTF8StringRef();
    }
}

